#!/bin/sh

# iSub.sh

APDIR=~/Desktop

##### Preparation #####

echo Changing directory...
cd $APDIR

##### Backing up current kext #####

echo Making Folder to insert old extension in...
mkdir OldExtension

echo Copying current extension to OldExtension folder...
cp -r /System/Library/Extensions/AppleUSBAudio.kext ~/Desktop/OldExtension

##### Installing files ######

echo Copying new extension to /System/Library/Extensions...
echo If asked, please enter your password...
sudo cp -r AppleUSBAudio.kext /System/Library/Extensions

echo Changing extension permissions...
sudo chmod -R 755 /System/Library/Extensions/AppleUSBAudio.kext

echo Changing extension owner...
sudo chown -R root:wheel /System/Library/Extensions/AppleUSBAudio.kext

##### Deleteing extensions cache #####

echo Deleteing extensions cache...
sudo rm /System/Library/Extensions.mkext
sudo rm /System/Library/Extensions.kextcache

##### End of installation, asking user to restart ######

echo
echo
echo Installation complete, please restart.